<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CashierResource;
use App\Http\Resources\CashierCollection;

class UserCashiersController extends Controller
{
    public function index(Request $request, User $user): CashierCollection
    {
        $this->authorize('view', $user);

        $search = $request->get('search', '');

        $cashiers = $user
            ->cashiers()
            ->search($search)
            ->latest()
            ->paginate();

        return new CashierCollection($cashiers);
    }

    public function store(Request $request, User $user): CashierResource
    {
        $this->authorize('create', Cashier::class);

        $validated = $request->validate([
            'cashier_name' => ['required', 'max:255', 'string'],
            'cashier_type' => ['required', 'in:supervisor,cashier'],
            'start_time' => ['required', 'date_format:H:i:s'],
            'end_time' => ['required', 'date_format:H:i:s'],
        ]);

        $cashier = $user->cashiers()->create($validated);

        return new CashierResource($cashier);
    }
}
