<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CashierShiftResource;
use App\Http\Resources\CashierShiftCollection;

class UserCashierShiftsController extends Controller
{
    public function index(Request $request, User $user): CashierShiftCollection
    {
        $this->authorize('view', $user);

        $search = $request->get('search', '');

        $cashierShifts = $user
            ->cashierShifts()
            ->search($search)
            ->latest()
            ->paginate();

        return new CashierShiftCollection($cashierShifts);
    }

    public function store(Request $request, User $user): CashierShiftResource
    {
        $this->authorize('create', CashierShift::class);

        $validated = $request->validate([
            'cashier_id' => ['required', 'exists:cashiers,id'],
            'start_time' => ['required', 'date_format:H:i:s'],
            'end_time' => ['required', 'date_format:H:i:s'],
            'starting_amount' => ['required', 'numeric'],
            'ending_amount' => ['required', 'numeric'],
        ]);

        $cashierShift = $user->cashierShifts()->create($validated);

        return new CashierShiftResource($cashierShift);
    }
}
