<?php

namespace App\Http\Controllers\Api;

use App\Models\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AccountResource;
use App\Http\Resources\AccountCollection;

class CustomerAccountsController extends Controller
{
    public function index(
        Request $request,
        Customer $customer
    ): AccountCollection {
        $this->authorize('view', $customer);

        $search = $request->get('search', '');

        $accounts = $customer
            ->accounts()
            ->search($search)
            ->latest()
            ->paginate();

        return new AccountCollection($accounts);
    }

    public function store(Request $request, Customer $customer): AccountResource
    {
        $this->authorize('create', Account::class);

        $validated = $request->validate([
            'account_number' => ['required', 'max:255', 'string'],
            'balance' => ['required', 'numeric'],
            'account_type' => ['required', 'in:savings,checking'],
        ]);

        $account = $customer->accounts()->create($validated);

        return new AccountResource($account);
    }
}
