<?php

namespace App\Http\Controllers\Api;

use App\Models\CashierShift;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Http\Resources\CashierShiftResource;
use App\Http\Resources\CashierShiftCollection;
use App\Http\Requests\CashierShiftStoreRequest;
use App\Http\Requests\CashierShiftUpdateRequest;

class CashierShiftController extends Controller
{
    public function index(Request $request): CashierShiftCollection
    {
        $this->authorize('view-any', CashierShift::class);

        $search = $request->get('search', '');

        $cashierShifts = CashierShift::search($search)
            ->latest()
            ->paginate();

        return new CashierShiftCollection($cashierShifts);
    }

    public function store(
        CashierShiftStoreRequest $request
    ): CashierShiftResource {
        $this->authorize('create', CashierShift::class);

        $validated = $request->validated();

        $cashierShift = CashierShift::create($validated);

        return new CashierShiftResource($cashierShift);
    }

    public function show(
        Request $request,
        CashierShift $cashierShift
    ): CashierShiftResource {
        $this->authorize('view', $cashierShift);

        return new CashierShiftResource($cashierShift);
    }

    public function update(
        CashierShiftUpdateRequest $request,
        CashierShift $cashierShift
    ): CashierShiftResource {
        $this->authorize('update', $cashierShift);

        $validated = $request->validated();

        $cashierShift->update($validated);

        return new CashierShiftResource($cashierShift);
    }

    public function destroy(
        Request $request,
        CashierShift $cashierShift
    ): Response {
        $this->authorize('delete', $cashierShift);

        $cashierShift->delete();

        return response()->noContent();
    }
}
