<?php

namespace App\Http\Controllers\Api;

use App\Models\Cashier;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Http\Resources\CashierResource;
use App\Http\Resources\CashierCollection;
use App\Http\Requests\CashierStoreRequest;
use App\Http\Requests\CashierUpdateRequest;

class CashierController extends Controller
{
    public function index(Request $request): CashierCollection
    {
        $this->authorize('view-any', Cashier::class);

        $search = $request->get('search', '');

        $cashiers = Cashier::search($search)
            ->latest()
            ->paginate();

        return new CashierCollection($cashiers);
    }

    public function store(CashierStoreRequest $request): CashierResource
    {
        $this->authorize('create', Cashier::class);

        $validated = $request->validated();

        $cashier = Cashier::create($validated);

        return new CashierResource($cashier);
    }

    public function show(Request $request, Cashier $cashier): CashierResource
    {
        $this->authorize('view', $cashier);

        return new CashierResource($cashier);
    }

    public function update(
        CashierUpdateRequest $request,
        Cashier $cashier
    ): CashierResource {
        $this->authorize('update', $cashier);

        $validated = $request->validated();

        $cashier->update($validated);

        return new CashierResource($cashier);
    }

    public function destroy(Request $request, Cashier $cashier): Response
    {
        $this->authorize('delete', $cashier);

        $cashier->delete();

        return response()->noContent();
    }
}
