<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Account;
use App\Models\Customer;

class DebugAccounts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'debug:accounts';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Debug accounts and customer relationships';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('=== DEBUGGING ACCOUNTS ===');

        // Get all accounts
        $this->info('1. All accounts in database:');
        $allAccounts = Account::all();
        foreach ($allAccounts as $account) {
            $this->line("   ID: {$account->id}, Customer ID: {$account->customer_id}, Currency: {$account->currency_id}");
        }

        $this->info("\n2. All customers:");
        $customers = Customer::all();
        foreach ($customers as $customer) {
            $this->line("   Customer ID: {$customer->id}, Email: {$customer->email}");
        }

        $this->info("\n3. Accounts with their relationships:");
        $accountsWithRelations = Account::with(['customer', 'currency'])->get();
        foreach ($accountsWithRelations as $account) {
            $this->line("   Account ID: {$account->id}");
            $this->line("     Customer: " . ($account->customer ? $account->customer->email : 'NULL'));
            $this->line("     Currency: " . ($account->currency ? $account->currency->currency_name : 'NULL'));
            $this->line("");
        }

        $this->info("\n4. Testing account lookup for customer ID 1:");
        $customerId = 1;
        $customerAccounts = Account::where('customer_id', $customerId)->get();
        $this->line("   Found " . $customerAccounts->count() . " accounts for customer $customerId");
        foreach ($customerAccounts as $account) {
            $this->line("     Account ID: {$account->id}, Currency: {$account->currency_id}");
        }

        $this->info("\n5. Testing specific account lookup (ID 1):");
        $account = Account::with('customer')->find(1);
        if ($account) {
            $this->line("   Account ID: {$account->id}");
            $this->line("   Customer ID: {$account->customer_id}");
            $this->line("   Customer Email: " . ($account->customer ? $account->customer->email : 'NULL'));
            $this->line("   Currency ID: {$account->currency_id}");
        } else {
            $this->line("   Account with ID 1 not found");
        }

        $this->info("\n=== DEBUG COMPLETE ===");
    }
}
