# Troubleshooting 2FA Issue

## Problem
When clicking "Enable" for 2FA, something shows in the console but nothing appears on the page.

## Possible Causes & Solutions

### 1. Check Browser Console
Please check your browser console (F12) and look for any JavaScript errors. Common errors might be:
- `Alpine is not defined`
- `Livewire` errors
- `$wire is not defined`

### 2. Verify Livewire is Working
Run this test in your browser console on the profile page:
```javascript
console.log(Livewire);
console.log(Alpine);
```

### 3. Check if Modal Components are Rendering
The password confirmation uses Alpine.js and Bootstrap modals. Ensure:
- Alpine.js is loaded (it's included with Livewire 3)
- Bootstrap modal JS is loaded
- jQuery is loaded (for Bootstrap modals)

### 4. Clear All Caches
Run these commands:
```bash
php artisan optimize:clear
php artisan view:clear
php artisan config:clear
php artisan route:clear
php artisan cache:clear
```

### 5. Check Livewire Version Compatibility
The current setup uses Livewire 3.4.4. The `wire:model.live` syntax is correct for Livewire 3.

### 6. Test Basic Livewire Functionality
Create a simple test to see if Livewire works:
```bash
php artisan make:livewire TestComponent
```

### 7. Check for JavaScript Conflicts
Look in the console for:
- jQuery conflicts
- Alpine.js conflicts  
- Bootstrap JS conflicts

### 8. Verify Bootstrap Modal Setup
The modal uses Bootstrap's modal component. Make sure:
- Bootstrap JS is loaded before Livewire scripts
- No conflicting modal libraries

## Quick Debug Steps

1. **Open Browser DevTools** (F12)
2. **Go to Console tab**
3. **Navigate to** `/user/profile`
4. **Click "Enable"** button for 2FA
5. **Share the console output**

## Common Console Errors & Fixes

### Error: "Alpine is not defined"
**Solution**: Ensure Livewire scripts are loaded. Alpine is bundled with Livewire 3.

### Error: "$wire is not defined"
**Solution**: The component isn't properly initialized. Check if `@livewireScripts` is present.

### Error: Modal doesn't show
**Solution**: Check if Bootstrap modal JS and jQuery are loaded correctly.

## Testing Commands

```bash
# Rebuild assets
npm run dev

# Or for production
npm run build

# Clear everything
php artisan optimize:clear

# Restart development server
php artisan serve
```

## Manual Testing Without Password Confirmation

To test if the issue is with password confirmation, you can temporarily disable it:

1. Edit `config/fortify.php`
2. Change:
```php
Features::twoFactorAuthentication([
    'confirm' => true,
    'confirmPassword' => false,  // Set this to false
]),
```
3. Run: `php artisan config:clear`
4. Test again

## What to Check in Console

When you click "Enable", you should see:
1. Livewire request being made
2. A modal should pop up asking for password
3. No JavaScript errors

## Next Steps

Please share:
1. The exact error message from browser console
2. Your browser name and version
3. Whether any modal appears at all (even if empty)
4. The network tab showing XHR requests when clicking Enable

