# OneSignal Test Notification Page Guide

## Overview
A dedicated test page has been created to safely test OneSignal notifications in your production environment without affecting real transactions.

## Access
Navigate to: **`/test-notifications`** in your browser
Or use the menu: **Testing Tools → Test Notifications**

## Features

### 1. **Configuration Status Check**
- Click "Check Config" to verify OneSignal configuration
- Shows App ID, REST API Key status
- Displays user coverage statistics

### 2. **Individual User Test**
- Select a specific user from the dropdown
- Send a custom test message
- Verify notifications work for specific users
- Shows user's OneSignal player ID

### 3. **Transaction Notification Test**
- Select from recent transactions
- Choose notification type (completed, approved, rejected)
- Test transaction-specific notifications
- Simulates real transaction notification flow

### 4. **Broadcast Test**
- Send notification to ALL users with OneSignal player IDs
- Use with caution in production
- Good for system-wide announcements
- Shows total user count

### 5. **User List**
- View all users with OneSignal player IDs
- See customer associations
- Verify user setup

## Testing Workflow

### **Step 1: Check Configuration**
1. Click "Check Config" button
2. Verify all settings are "Set"
3. Check user coverage percentage

### **Step 2: Test Individual Notifications**
1. Select a user from dropdown
2. Optionally add custom message
3. Click "Send Test Notification"
4. Check mobile device for notification

### **Step 3: Test Transaction Notifications**
1. Select a recent transaction
2. Choose notification type
3. Click "Send Transaction Notification"
4. Verify notification content

### **Step 4: Test Broadcast (Optional)**
1. Add custom message if needed
2. Click "Send to All Users"
3. Monitor multiple devices

## Safety Features

- **Production Safe**: No real transactions are affected
- **Error Handling**: Failed notifications don't break the system
- **Logging**: All attempts are logged for debugging
- **User Selection**: Only users with player IDs are shown
- **Confirmation**: Clear success/error messages

## Troubleshooting

### **No Users Showing**
- Ensure users have logged into mobile app
- Check OneSignal player IDs are being saved
- Verify mobile app OneSignal integration

### **Notifications Not Received**
- Check OneSignal dashboard for delivery status
- Verify device notification permissions
- Check Laravel logs for errors

### **Configuration Issues**
- Ensure `.env` file has OneSignal credentials
- Verify OneSignal app is properly configured
- Check REST API key permissions

## API Endpoints

The test page uses these API endpoints:

- `GET /test-notifications` - Main test page
- `POST /test-notification/send` - Send individual notification
- `POST /test-notification/transaction` - Send transaction notification
- `POST /test-notification/broadcast` - Send broadcast notification
- `GET /test-notification/config` - Get configuration status

## Security

- All routes are protected by authentication middleware
- Only accessible to logged-in users
- CSRF protection on all forms
- Input validation on all endpoints

## Monitoring

Monitor the following for successful testing:

1. **Laravel Logs**: Check for notification attempts and errors
2. **OneSignal Dashboard**: Verify notification delivery
3. **Mobile Devices**: Confirm notifications are received
4. **Response Messages**: Check success/error feedback on page

## Best Practices

1. **Start Small**: Test with individual users first
2. **Check Logs**: Monitor Laravel logs during testing
3. **Verify Setup**: Ensure mobile app integration is working
4. **Test Regularly**: Run tests after any changes
5. **Document Issues**: Note any problems for debugging

This test page provides a safe way to verify OneSignal integration without affecting your production transaction flow.




















