# Statistics Feature - Backend Setup Guide

## 🎯 What Was Added

### New Files Created:
1. ✅ `database/migrations/2025_10_12_000000_create_currency_rate_history_table.php`
2. ✅ `app/Models/CurrencyRateHistory.php`
3. ✅ `app/Http/Controllers/Api/StatisticsController.php`
4. ✅ `database/seeders/CurrencyRateHistorySeeder.php`
5. ✅ `app/Console/Commands/RecordCurrencyRates.php`

### Modified Files:
1. ✅ `routes/api.php` - Added statistics routes

---

## 🚀 Setup Instructions

### Step 1: Run Migration
```bash
cd /Users/esramuhannad/Development/cash-nrx
php artisan migrate
```

This creates the `currency_rate_history` table.

### Step 2: Seed Sample Data (Optional but Recommended)
```bash
php artisan db:seed --class=CurrencyRateHistorySeeder
```

This will create 30 days of sample rate history for testing.

### Step 3: Test the API Endpoints

**Test Transaction Statistics:**
```bash
curl -X GET "https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

**Test Currency Rate History:**
```bash
curl -X GET "https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/currency-rates/1?days=30" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Accept: application/json"
```

### Step 4: Set Up Daily Rate Recording (Optional)

Add to `app/Console/Kernel.php` in the `schedule()` method:

```php
protected function schedule(Schedule $schedule): void
{
    // Record currency rates daily at midnight
    $schedule->command('currency:record-rates')->daily();
}
```

Or manually record rates anytime:
```bash
php artisan currency:record-rates
```

---

## 📡 API Endpoints

### 1. Transaction Statistics
```
GET /api/mobile/statistics/transactions
Authorization: Bearer {token}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "overview": {
      "total_transactions": 847,
      "this_month": 52,
      "last_30_days": 45,
      "active_currencies": 3
    },
    "monthly_stats": [
      {
        "month": "2025-01",
        "month_name": "Jan",
        "year": 2025,
        "count": 52,
        "deposits": 30,
        "withdrawals": 15,
        "transfers": 7
      }
      // ... 12 months
    ],
    "currency_breakdown": [
      {
        "currency_id": 1,
        "currency_name": "USD",
        "currency_code": "USD",
        "transaction_count": 382,
        "total_amount": 150000.00,
        "percentage": 45.0,
        "avg_transaction": 392.67
      }
      // ... other currencies
    ],
    "transaction_types": {
      "deposits": {"count": 512, "percentage": 60.0},
      "withdrawals": {"count": 255, "percentage": 30.0},
      "transfers": {"count": 80, "percentage": 10.0}
    }
  }
}
```

### 2. Currency Rate History
```
GET /api/mobile/statistics/currency-rates/{currency_id}?days=30
Authorization: Bearer {token}
```

**Parameters:**
- `currency_id` (required) - ID of currency
- `days` (optional) - Number of days (default: 30, max: 365)

**Response:**
```json
{
  "success": true,
  "data": {
    "currency": {
      "id": 1,
      "name": "USD",
      "code": "USD"
    },
    "current": {
      "buy_rate": 1548.00,
      "sell_rate": 1550.00,
      "last_updated": "2025-01-30T10:00:00Z"
    },
    "history": [
      {
        "date": "2025-01-01",
        "buy_rate": 1510.00,
        "sell_rate": 1512.00,
        "timestamp": "2025-01-01T00:00:00Z"
      }
      // ... daily records
    ],
    "statistics": {
      "period_days": 30,
      "high": 1550.00,
      "low": 1510.00,
      "average": 1530.00,
      "change_amount": 38.00,
      "change_percentage": 2.45,
      "trend": "up",
      "volatility": "low",
      "data_available": true
    }
  }
}
```

---

## ✅ Verification Checklist

- [ ] Migration ran successfully
- [ ] Sample data seeded (optional)
- [ ] Transaction statistics endpoint returns data
- [ ] Currency rate history endpoint returns data
- [ ] Daily rate recording command works
- [ ] Schedule set up (if using automated recording)

---

## 🔧 Troubleshooting

**No data in statistics:**
- Make sure customer has transactions
- Check that accounts exist
- Verify transactions are not rejected

**No rate history:**
- Run the seeder: `php artisan db:seed --class=CurrencyRateHistorySeeder`
- Or record current rates: `php artisan currency:record-rates`

**500 Error:**
- Check Laravel logs: `storage/logs/laravel.log`
- Verify migration ran
- Check database connection

---

✅ Backend is ready! Move to Flutter implementation next.

