# 📮 Postman Test Guide - Statistics API

## 🎯 API Endpoints for Testing

### **Endpoint 1: Transaction Statistics**
```
GET https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions
```

### **Endpoint 2: Currency Rate History**
```
GET https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/currency-rates/1?days=30
```
(Replace `1` with currency ID, `30` with number of days)

---

## 📋 Postman Setup

### Request 1: Transaction Statistics

**Method:** `GET`

**URL:** 
```
https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions
```

**Headers:**
```
Authorization: Bearer 145|PrMu0O6y1GaRGl1hJJAjJqHu2gRFBFpv483ttIiZce761055
Accept: application/json
Content-Type: application/json
```

**Expected Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "overview": {
      "total_transactions": 9,
      "this_month": 0,
      "last_30_days": 2,
      "active_currencies": 2
    },
    "monthly_stats": [
      {
        "month": "2024-11",
        "month_name": "Nov",
        "year": 2024,
        "count": 5,
        "deposits": 0,
        "withdrawals": 5,
        "transfers": 0
      }
      // ... more months
    ],
    "currency_breakdown": [
      {
        "currency_id": 2,
        "currency_name": "IQD",
        "currency_code": "IQD",
        "transaction_count": 9,
        "total_amount": 450000.0,
        "percentage": 100.0,
        "avg_transaction": 50000.0
      }
    ],
    "transaction_types": {
      "deposits": {"count": 0, "percentage": 0},
      "withdrawals": {"count": 9, "percentage": 100.0},
      "transfers": {"count": 0, "percentage": 0}
    }
  }
}
```

**If you get 404:** The server hasn't pulled the code or run migrations yet.

---

### Request 2: Currency Rate History

**Method:** `GET`

**URL:**
```
https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/currency-rates/2?days=30
```
(Use currency_id=2 for IQD, or 1 for USD)

**Headers:**
```
Authorization: Bearer 145|PrMu0O6y1GaRGl1hJJAjJqHu2gRFBFpv483ttIiZce761055
Accept: application/json
Content-Type: application/json
```

**Expected Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "currency": {
      "id": 2,
      "name": "IQD",
      "code": "IQD"
    },
    "current": {
      "buy_rate": 1410.00,
      "sell_rate": 1420.00,
      "last_updated": "2025-10-12T..."
    },
    "history": [
      {
        "date": "2025-09-12",
        "buy_rate": 1405.00,
        "sell_rate": 1415.00,
        "timestamp": "..."
      }
      // ... 30 days
    ],
    "statistics": {
      "period_days": 30,
      "high": 1420.00,
      "low": 1390.00,
      "average": 1405.00,
      "change_amount": 5.00,
      "change_percentage": 0.35,
      "trend": "up",
      "volatility": "low",
      "data_available": true
    }
  }
}
```

**If you get 404:** Rate history table doesn't exist or no data seeded.

---

## 🔍 Possible 404 Causes

### Cause 1: Code Not Deployed to Production
**Check:** Are the new files on the server?
**Fix:** SSH to server and run `git pull origin main`

### Cause 2: Routes Not Cached/Updated
**Check:** Are routes recognized?
**Fix:** SSH to server and run `php artisan route:clear && php artisan optimize:clear`

### Cause 3: Migration Not Run
**Check:** Does `currency_rate_history` table exist?
**Fix:** SSH to server and run `php artisan migrate --force`

### Cause 4: No Data in Tables
**Check:** Is database empty?
**Fix:** SSH to server and run seeders

---

## 🧪 Test Sequence in Postman

### Test 1: Verify Route Exists
```
GET https://LA DERMA.innovation-pulsehub.com/api/mobile/user
```
- If this works (200 OK): Auth is fine
- If this fails (404/401): Auth issue

### Test 2: Test Statistics
```
GET https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions
```
- If 404: StatisticsController not deployed or routes not updated
- If 500: Code error (check server logs)
- If 200: ✅ Working!

### Test 3: Test Rate History
```
GET https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/currency-rates/2?days=30
```
- If 404: Migration not run or table missing
- If 500: Seeder not run or no data
- If 200: ✅ Working!

---

## 🔧 Debug on Production Server

### Check 1: Are Files There?

SSH to server and run:
```bash
cd /home/forge/LA DERMA.innovation-pulsehub.com

ls -la app/Http/Controllers/Api/StatisticsController.php
ls -la app/Models/CurrencyRateHistory.php
ls -la database/migrations/*currency_rate_history*
```

**Expected:** Files should exist
**If not:** Run `git pull origin main`

---

### Check 2: Is Migration Run?

```bash
php artisan migrate:status | grep currency_rate_history
```

**Expected:** `Ran` status
**If "Pending":** Run `php artisan migrate --force`

---

### Check 3: Are Routes Registered?

```bash
php artisan route:list | grep statistics
```

**Expected:** 
```
GET  api/mobile/statistics/transactions
GET  api/mobile/statistics/currency-rates/{currency}
```

**If empty:** Run `php artisan route:clear && php artisan optimize:clear`

---

### Check 4: Is Data Seeded?

```bash
php artisan tinker

>>> \App\Models\CurrencyRateHistory::count();
// Should return number > 0

>>> \App\Models\AppVersion::count();
// Should return 2

>>> exit
```

**If 0:** Run seeders

---

## ⚡ Quick Fix Commands (On Server)

If you get 404 in Postman, SSH to server and run:

```bash
cd /home/forge/LA DERMA.innovation-pulsehub.com

# Pull latest code
git pull origin main

# Run migrations
php artisan migrate --force

# Seed data
php artisan db:seed --class=AppVersionSeeder
php artisan db:seed --class=CurrencyRateHistorySeeder

# Clear all caches
php artisan optimize:clear
php artisan config:clear
php artisan route:clear

# Recache for production
php artisan config:cache
php artisan route:cache
```

Then test again in Postman!

---

## 📱 Your Token (For Postman)

```
145|PrMu0O6y1GaRGl1hJJAjJqHu2gRFBFpv483ttIiZce761055
```

---

## 🎯 Summary

**Routes Location:** `routes/api.php` lines 128-130 ✅
**Controller:** `app/Http/Controllers/Api/StatisticsController.php` ✅
**Code Pushed:** Check with Fork app history ✅
**Server Updated:** ❓ Need to verify
**Migration Run:** ❓ Need to verify
**Data Seeded:** ❓ Need to verify

---

## 💡 Most Likely Issue

**Your production server** hasn't:
1. ❌ Pulled the latest code from GitHub
2. ❌ Run the new migration
3. ❌ Run the seeders

**Solution:** SSH to server and run the commands above!

---

**Test in Postman now**, then we'll know exactly what's missing! 📮

