# OneSignal Setup Instructions

## Backend Configuration

### 1. Environment Variables
Add the following variables to your `.env` file:

```env
# OneSignal Configuration
ONESIGNAL_APP_ID=your_onesignal_app_id_here
ONESIGNAL_REST_API_KEY=your_onesignal_rest_api_key_here
ONESIGNAL_USER_AUTH_KEY=your_onesignal_user_auth_key_here
```

### 2. OneSignal Dashboard Setup
1. Go to [OneSignal Dashboard](https://app.onesignal.com/)
2. Create a new app or select existing app
3. Choose "Web Push" or "Mobile App" based on your needs
4. Get your App ID from Settings > Keys & IDs
5. Get your REST API Key from Settings > Keys & IDs

### 3. Database Migration
Run the migration to add OneSignal player ID to users table:
```bash
php artisan migrate
```

### 4. API Endpoints
The following API endpoints are available for OneSignal integration:

- `POST /api/mobile/onesignal/player-id` - Update user's OneSignal player ID
- `GET /api/mobile/onesignal/player-id` - Get user's OneSignal player ID
- `POST /api/mobile/onesignal/test` - Send test notification

## Mobile App Integration

### Flutter Dependencies
Add OneSignal to your `pubspec.yaml`:

```yaml
dependencies:
  onesignal_flutter: ^5.0.0
```

### Initialize OneSignal
Add OneSignal initialization to your main.dart:

```dart
import 'package:onesignal_flutter/onesignal_flutter.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  
  // Initialize OneSignal
  OneSignal.initialize("YOUR_ONESIGNAL_APP_ID");
  
  runApp(MyApp());
}
```

### Update Player ID
Send the player ID to your backend when user logs in:

```dart
// Get OneSignal player ID
String? playerId = await OneSignal.User.getOnesignalId();

// Send to backend
if (playerId != null) {
  await apiService.updateOneSignalPlayerId(playerId);
}
```

## Notification Types

The system sends notifications for:

1. **Transaction Created** - When a new transaction is created
2. **Transaction Approved** - When a transaction is approved
3. **Transaction Rejected** - When a transaction is rejected

## Testing

Use the test endpoint to verify OneSignal integration:
```bash
curl -X POST "http://your-domain/api/mobile/onesignal/test" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json"
```






























