-- SQL script to insert app version data
-- Run this in your database if you prefer SQL over seeder

-- Clear existing data (optional)
TRUNCATE TABLE app_versions;

-- Insert Android version
INSERT INTO app_versions (
    version,
    version_code,
    platform,
    release_notes,
    download_url,
    min_supported_version,
    is_active,
    is_force_update,
    created_at,
    updated_at
) VALUES (
    '1.0.15',
    15,
    'android',
    '• Fixed notification preferences API routes\n• Improved biometric authentication flow\n• Bug fixes and performance improvements',
    'https://play.google.com/store/apps/details?id=com.LA DERMA.mobile',
    '1.0.0',
    1,
    0,
    NOW(),
    NOW()
);

-- Insert iOS version
INSERT INTO app_versions (
    version,
    version_code,
    platform,
    release_notes,
    download_url,
    min_supported_version,
    is_active,
    is_force_update,
    created_at,
    updated_at
) VALUES (
    '1.0.15',
    15,
    'ios',
    '• Fixed notification preferences API routes\n• Improved biometric authentication flow\n• Bug fixes and performance improvements',
    'https://apps.apple.com/app/LA DERMA/id123456789',
    '1.0.0',
    1,
    0,
    NOW(),
    NOW()
);

-- Verify the data
SELECT * FROM app_versions ORDER BY created_at DESC;

