# 🔧 Fix 404 Errors - Quick Setup Guide

## ❌ Current Issues

From your app logs:
```
❌ AppUpdateService: API response: 404
❌ Failed to load statistics: 404
```

## ✅ Solution (5 Minutes)

### Step 1: Open Terminal

Open a new Terminal window (not from Cursor) and navigate to backend:

```bash
cd /Users/esramuhannad/Development/cash-nrx
```

---

### Step 2: Run Migration (Creates Tables)

```bash
php artisan migrate
```

**Expected Output:**
```
Running migrations.
2025_10_12_000000_create_currency_rate_history_table ............... DONE
```

---

### Step 3: Seed App Version Data

```bash
php artisan db:seed --class=AppVersionSeeder
```

**Expected Output:**
```
✅ App versions seeded successfully!
```

---

### Step 4: Seed Currency Rate History

```bash
php artisan db:seed --class=CurrencyRateHistorySeeder
```

**Expected Output:**
```
Seeding currency rate history...
✓ Created 31 days of history for USD
✓ Created 31 days of history for IQD
✓ Created 31 days of history for EURO
✅ Currency rate history seeded successfully!
```

---

### Step 5: Test APIs

**Test Statistics:**
```bash
curl -X GET "https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions" \
  -H "Authorization: Bearer 145|PrMu0O6y1GaRGl1hJJAjJqHu2gRFBFpv483ttIiZce761055" \
  -H "Accept: application/json"
```

**Test App Version:**
```bash
curl -X GET "https://LA DERMA.innovation-pulsehub.com/api/mobile/app-version" \
  -H "X-Platform: ios" \
  -H "X-App-Version: 1.0.14" \
  -H "Accept: application/json"
```

**Expected:** Both should return JSON with `"success": true`

---

### Step 6: Restart Flutter App

In Cursor terminal or in the app:
- Press `r` to hot reload
- Or press `R` to hot restart
- Or stop and run: `flutter run`

---

## ✅ Verification

After running the commands, you should see in app logs:

```
✅ Statistics loaded successfully
✅ AppUpdateService: Latest version: 1.0.15
```

Instead of:
```
❌ Failed to load statistics: 404
❌ AppUpdateService: API response: 404
```

---

## 🎯 Quick Commands (Copy & Paste)

**All in one:**
```bash
cd /Users/esramuhannad/Development/cash-nrx && \
php artisan migrate && \
php artisan db:seed --class=AppVersionSeeder && \
php artisan db:seed --class=CurrencyRateHistorySeeder && \
echo "✅ Setup complete!"
```

---

## 📊 What This Does

### Migration:
- Creates `currency_rate_history` table
- Enables rate tracking feature

### App Version Seeder:
- Adds version 1.0.15 for Android
- Adds version 1.0.15 for iOS
- Fixes the 404 error for app updates

### Rate History Seeder:
- Creates 30 days of sample rate data
- Enables statistics charts to show data
- Fixes the 404 for statistics endpoint

---

## 🐛 Troubleshooting

### If Migration Fails:
```bash
# Check if table already exists
php artisan migrate:status

# If it shows the migration already ran, skip it
```

### If Seeder Fails:
```bash
# Check if data exists
php artisan tinker
>>> \App\Models\AppVersion::count();
>>> \App\Models\CurrencyRateHistory::count();
>>> exit

# If count > 0, data already exists
```

### If API Still Returns 404:
```bash
# Clear cache
php artisan optimize:clear
php artisan config:clear
php artisan route:clear

# Check routes are registered
php artisan route:list | grep statistics
```

---

## 🎉 After Setup

Your app will show:
- ✅ Beautiful statistics charts
- ✅ Currency rate trends
- ✅ Monthly transaction graphs
- ✅ App update notifications (when you publish version 1.0.15)

---

## 💡 Quick Test

After setup, in the app:
1. Go to **Profile** tab
2. Tap **Statistics** 
3. You should see:
   - Overview cards
   - Monthly chart
   - Currency pie chart
   - Rate history chart

---

**Run the commands now and the errors will be fixed!** 🚀

**Any issues?** Check the troubleshooting section above.

