# 🚀 Deploy Statistics Feature to Production

## 🎯 Current Situation

✅ **Local Files:** All created and ready
❌ **Production Server:** Needs files uploaded + migration run

**Server:** LA DERMA.innovation-pulsehub.com

---

## 📦 Files That Need to Be Deployed

### New Files (5):
1. `database/migrations/2025_10_12_000000_create_currency_rate_history_table.php`
2. `app/Models/CurrencyRateHistory.php`
3. `app/Http/Controllers/Api/StatisticsController.php`
4. `database/seeders/CurrencyRateHistorySeeder.php`
5. `app/Console/Commands/RecordCurrencyRates.php`

### Modified Files (1):
1. `routes/api.php` - Added StatisticsController

### Seeder (Already Exists):
1. `database/seeders/AppVersionSeeder.php` - For app version fix

---

## 🚀 DEPLOYMENT OPTIONS

### **Option 1: Git Push + Laravel Forge (Recommended)**

If you're using Laravel Forge or similar:

```bash
cd /Users/esramuhannad/Development/cash-nrx

# 1. Add files to git
git add .

# 2. Commit
git commit -m "Add statistics feature with currency rate history tracking"

# 3. Push to repository
git push origin main

# 4. Laravel Forge will auto-deploy
# Wait 1-2 minutes for deployment

# 5. SSH into server and run:
ssh forge@LA DERMA.innovation-pulsehub.com
cd /home/forge/LA DERMA.innovation-pulsehub.com
php artisan migrate --force
php artisan db:seed --class=AppVersionSeeder
php artisan db:seed --class=CurrencyRateHistorySeeder
exit
```

---

### **Option 2: Manual SSH Deployment**

```bash
# 1. SSH into your server
ssh YOUR_USERNAME@LA DERMA.innovation-pulsehub.com

# 2. Navigate to project
cd /home/forge/LA DERMA.innovation-pulsehub.com
# OR
cd /var/www/LA DERMA.innovation-pulsehub.com

# 3. Pull latest code (if using git)
git pull origin main

# 4. Run migrations
php artisan migrate --force

# 5. Seed app versions
php artisan db:seed --class=AppVersionSeeder

# 6. Seed rate history
php artisan db:seed --class=CurrencyRateHistorySeeder

# 7. Clear cache
php artisan optimize:clear

# 8. Exit
exit
```

---

### **Option 3: Manual File Upload (If No Git)**

If not using git:

**Step 1: Upload Files via FTP/SFTP**

Using FileZilla, Cyberduck, or similar:

1. Connect to: `LA DERMA.innovation-pulsehub.com`
2. Navigate to project root
3. Upload these files:
   - `app/Models/CurrencyRateHistory.php`
   - `app/Http/Controllers/Api/StatisticsController.php`
   - `app/Console/Commands/RecordCurrencyRates.php`
   - `database/migrations/2025_10_12_000000_create_currency_rate_history_table.php`
   - `database/seeders/CurrencyRateHistorySeeder.php`
   - `database/seeders/AppVersionSeeder.php`
   - `routes/api.php` (overwrite)

**Step 2: SSH and Run Commands**

```bash
ssh YOUR_USERNAME@LA DERMA.innovation-pulsehub.com
cd /path/to/project
php artisan migrate --force
php artisan db:seed --class=AppVersionSeeder
php artisan db:seed --class=CurrencyRateHistorySeeder
php artisan optimize:clear
```

---

## 🔍 Find Your Server Details

### Check Laravel Forge:
- Go to https://forge.laravel.com
- Find your site: LA DERMA.innovation-pulsehub.com
- Click "Deploy Now" button
- Or check SSH access details

### Check Your Hosting Panel:
- cPanel / Plesk / DirectAdmin
- Find SSH access credentials
- Connect and run commands

---

## ✅ Verification After Deployment

### Test 1: Check Migration
```bash
# On server
php artisan migrate:status | grep currency_rate_history
```

Should show: `Ran` next to currency_rate_history

### Test 2: Check Seeders
```bash
# On server
php artisan tinker

>>> \App\Models\AppVersion::count();
// Should return: 2

>>> \App\Models\CurrencyRateHistory::count();
// Should return: 31+ (depends on currencies)

>>> exit
```

### Test 3: Test API
```bash
# From your Mac
curl https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions \
  -H "Authorization: Bearer 145|PrMu0O6y1GaRGl1hJJAjJqHu2gRFBFpv483ttIiZce761055"
```

Should return JSON with success: true

---

## 🎯 Quick Deploy Script

Save this and run on the server:

```bash
#!/bin/bash
# deploy_statistics.sh - Run this on production server

echo "🚀 Deploying Statistics Feature..."

# Pull latest code (if using git)
git pull origin main

# Run migrations
php artisan migrate --force

# Seed data
php artisan db:seed --class=AppVersionSeeder
php artisan db:seed --class=CurrencyRateHistorySeeder

# Clear caches
php artisan optimize:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Restart queues (if using)
php artisan queue:restart

echo "✅ Deployment complete!"
echo ""
echo "Test the API:"
echo "curl https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions -H 'Authorization: Bearer YOUR_TOKEN'"
```

---

## 🔧 Common Server Paths

Try these paths:
- `/home/forge/LA DERMA.innovation-pulsehub.com`
- `/var/www/LA DERMA.innovation-pulsehub.com`
- `/home/LA DERMA/LA DERMA.innovation-pulsehub.com`
- `/home/www/LA DERMA.innovation-pulsehub.com`

---

## 🐛 Troubleshooting

### Can't Find PHP:
```bash
# Try these:
which php
php -v
/usr/bin/php -v
/usr/local/bin/php -v
```

### Permission Denied:
```bash
# Use sudo
sudo php artisan migrate
```

### Git Pull Fails:
```bash
# Stash local changes first
git stash
git pull origin main
```

### Migration Already Run:
```bash
# It's okay, skip it
# Just run the seeders
```

---

## 📞 Need SSH Access?

### Contact Your Hosting Provider:
- Request SSH access
- Get credentials:
  - Username
  - Password or SSH key
  - Port (usually 22)

### Or Use Laravel Forge:
- Click "SSH" button
- Copy command
- Run in terminal

---

## ⚡ FASTEST METHOD

### If Using Laravel Forge:

1. **Push Code:**
   ```bash
   cd /Users/esramuhannad/Development/cash-nrx
   git add .
   git commit -m "Add statistics feature"
   git push origin main
   ```

2. **Click "Deploy Now"** in Laravel Forge

3. **Run Deployment Script** (in Forge):
   ```bash
   php artisan migrate --force
   php artisan db:seed --class=AppVersionSeeder
   php artisan db:seed --class=CurrencyRateHistorySeeder
   ```

4. **Done!** ✅

---

## ✅ After Deployment

### Your App Will Show:
```
✅ Statistics loaded successfully
✅ AppUpdateService: Latest version: 1.0.15
📊 Monthly stats loaded
💱 Rate history loaded
```

Instead of:
```
❌ Failed to load statistics: 404
❌ AppUpdateService: API response: 404
```

---

## 🎯 Quick Checklist

- [ ] Code pushed to repository
- [ ] Deployed to production server
- [ ] Migration run on server
- [ ] App version seeder run
- [ ] Rate history seeder run
- [ ] Cache cleared
- [ ] API tested (returns 200)
- [ ] Flutter app restarted (press R)
- [ ] Statistics screen works!

---

**Need help accessing the server?** Check your hosting provider's documentation or contact their support.

**Using Laravel Forge?** It's just 1 click deploy + 3 commands!

**Questions?** Let me know your hosting setup and I'll provide specific instructions!

