# LA DERMA Mobile API Documentation

## Base URL
```
Production: https://LA DERMA.innovation-pulsehub.com/api/mobile
Development: http://localhost:8000/api/mobile
```

## Authentication
All protected endpoints require a Bearer token in the Authorization header:
```
Authorization: Bearer {your_token}
```

## Response Format
All API responses follow this format:
```json
{
    "success": true|false,
    "message": "Response message",
    "data": {}, // Response data (if success)
    "errors": {}, // Validation errors (if error)
    "timestamp": "2024-01-01T00:00:00.000000Z"
}
```

## Endpoints

### Authentication

#### POST /login
Login user and get access token.

**Request:**
```json
{
    "email": "admin@admin.com",
    "password": "admin"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Login successful",
    "data": {
        "user": {
            "id": 1,
            "name": "Admin User",
            "email": "admin@admin.com",
            "roles": ["admin"]
        },
        "token": "1|abc123...",
        "expires_at": "2024-02-01T00:00:00.000000Z"
    }
}
```

#### POST /register
Register new user.

**Request:**
```json
{
    "name": "John Doe",
    "email": "john@example.com",
    "password": "password123",
    "password_confirmation": "password123",
    "phone_number": "+1234567890",
    "address": "123 Main St"
}
```

#### GET /user
Get current authenticated user information.

**Response:**
```json
{
    "success": true,
    "data": {
        "user": {
            "id": 1,
            "name": "Admin User",
            "email": "admin@admin.com",
            "roles": ["admin"]
        },
        "customer": {
            "id": 1,
            "customer_name": "Admin User",
            "phone_number": "+1234567890",
            "address": "123 Main St"
        }
    }
}
```

#### POST /logout
Logout user and revoke token.

#### POST /refresh
Refresh access token.

### Accounts

#### GET /accounts
Get user's accounts.

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "account_title": "Main Account",
            "current_balance": 1000.00,
            "currency": {
                "id": 1,
                "currency_name": "US Dollar",
                "currency_code": "USD",
                "symbol": "$"
            }
        }
    ]
}
```

#### GET /accounts/{id}
Get specific account details.

#### GET /accounts/{id}/balance
Get account balance.

**Response:**
```json
{
    "success": true,
    "data": {
        "balance": 1000.00
    }
}
```

### Transactions

#### GET /transactions
Get user's transactions with pagination.

**Query Parameters:**
- `page` (optional): Page number (default: 1)
- `per_page` (optional): Items per page (default: 10)

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "transaction_type": "deposit",
            "transaction_amount": 100.00,
            "transaction_date": "2024-01-01T00:00:00.000000Z",
            "description": "Initial deposit",
            "account": {
                "id": 1,
                "account_title": "Main Account"
            }
        }
    ],
    "pagination": {
        "current_page": 1,
        "last_page": 1,
        "per_page": 10,
        "total": 1,
        "from": 1,
        "to": 1
    }
}
```

#### GET /transactions/{id}
Get specific transaction details.

#### POST /transactions
Create new transaction.

**Request:**
```json
{
    "transaction_type": "deposit",
    "transaction_amount": 100.00,
    "description": "Deposit description",
    "account_id": 1
}
```

### Profile

#### GET /profile
Get user profile information.

**Response:**
```json
{
    "success": true,
    "data": {
        "customer": {
            "id": 1,
            "customer_name": "John Doe",
            "phone_number": "+1234567890",
            "address": "123 Main St"
        }
    }
}
```

#### PUT /profile
Update user profile.

**Request:**
```json
{
    "customer_name": "John Doe Updated",
    "phone_number": "+1234567890",
    "address": "456 New St"
}
```

## Error Codes

- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `422` - Validation Error
- `429` - Too Many Requests
- `500` - Internal Server Error

## Rate Limiting

- Login/Register: 10 requests per minute
- API endpoints: 60 requests per minute

## Security Features

- JWT token authentication
- Rate limiting
- CORS protection
- Security headers
- Input validation
- SQL injection protection
- XSS protection

## Production Deployment Checklist

1. **Environment Configuration**
   - Set `APP_ENV=production`
   - Set `APP_DEBUG=false`
   - Configure database credentials
   - Set `APP_URL` to production domain

2. **Security**
   - Generate new `APP_KEY`
   - Configure HTTPS
   - Set up SSL certificates
   - Configure firewall rules

3. **Database**
   - Run migrations: `php artisan migrate`
   - Seed initial data: `php artisan db:seed`
   - Set up database backups

4. **Caching**
   - Configure Redis/Memcached
   - Enable route caching: `php artisan route:cache`
   - Enable config caching: `php artisan config:cache`
   - Enable view caching: `php artisan view:cache`

5. **Monitoring**
   - Set up error logging
   - Configure log rotation
   - Set up performance monitoring
   - Set up uptime monitoring

6. **API Configuration**
   - Update CORS origins for production domains
   - Configure rate limiting
   - Set up API documentation
   - Test all endpoints

## Testing

Use the following credentials for testing:
- Email: `admin@admin.com`
- Password: `admin`
